/*
	Stempora Web Framework
	Copyright (c) 2002-2018 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com				
*/

var STBPluginTweetThis = Object.create(STBModule.prototype);

STBPluginTweetThis.name = "PluginTweetThis";

STBPluginTweetThis.initPlugin = function() {
	var elements = jQuery(".tweet-this:not(.__done)");

	if (elements.length) {
		elements.click(function(e) {
			e.preventDefault();

			var 
				text	= jQuery(this).find(".tweet-this-content").text(),
				url		= "https://twitter.com/intent/tweet?text=" + escape(text) + "&url=" + escape(window.location.href),
				menu	= "width=566,height=592,location=yes,directories=no,channelmode=no,menubar=no,resizable=no,scrollbars=no,status=no,toolbar=no";


			window.open(
				url , 
				"tweetwindow",
				menu
			);

			jQuery(this).addClass("__done");
		})
	}
}

STBPluginTweetThis.runOnReady = function() {
	STBPluginTweetThis.initPlugin();
};

STBPluginTweetThis.runOnContentUpdate = function() {
	STBPluginTweetThis.initPlugin();
};

site.registerModule(STBPluginTweetThis);